/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.logs_analyser;

import dev.kostromdan.mods.crash_assistant.app.logs_analyser.Log;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogType;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.RegexChecker;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JDialog;

public class KnownCrashReason {
    protected HashSet<LogType> logTypes;
    protected List<String> patterns;
    protected String message;
    protected int priority;
    protected HashSet<String> conflictingReasons = new HashSet();
    public static HashSet<KnownCrashReason> shownKnownCrashReasons = new HashSet();
    protected LinkedHashMap<String, Consumer<JDialog>> autoFixButtons = new LinkedHashMap();

    protected KnownCrashReason(final LogType logType, String message, List<String> patterns) {
        this.logTypes = new HashSet<LogType>(){
            {
                this.add(logType);
            }
        };
        this.message = message;
        this.patterns = patterns;
    }

    protected KnownCrashReason(HashSet<LogType> logTypes, String message, List<String> patterns) {
        this.logTypes = logTypes;
        this.message = message;
        this.patterns = patterns;
    }

    protected KnownCrashReason(final LogType logType, String message, String ... patterns) {
        this.logTypes = new HashSet<LogType>(){
            {
                this.add(logType);
            }
        };
        this.message = message;
        this.patterns = Arrays.asList(patterns);
    }

    protected KnownCrashReason(HashSet<LogType> logTypes, String message, String ... patterns) {
        this.logTypes = logTypes;
        this.message = message;
        this.patterns = Arrays.asList(patterns);
    }

    HashSet<LogType> getLogTypes() {
        return this.logTypes;
    }

    public List<String> getPatterns() {
        return this.patterns;
    }

    public String getMessage() {
        return this.message;
    }

    public int getPriority() {
        return this.priority;
    }

    public HashSet<String> getConflictingReasons() {
        return this.conflictingReasons;
    }

    public LinkedHashMap<String, Consumer<JDialog>> getAutoFixButtons() {
        return this.autoFixButtons;
    }

    public boolean matches(Log log) {
        return RegexChecker.logContainsOneOfPatterns(log, this.patterns);
    }
}

